/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProject;

public abstract class AbstractSonarWebView
extends ViewPart {
    private Browser browser;

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
    }

    public final void setFocus() {
        this.browser.setFocus();
    }

    protected Browser getBrowser() {
        return this.browser;
    }

    protected void open(SonarLintProject sonarProject, String url) {
        this.browser.setUrl(url);
    }

    protected void showMessage(String message) {
        this.browser.setText("<p style=\"font: 13px arial,helvetica,clean,sans-serif;\">" + message + "</p>");
    }

    protected void showHtml(String html) {
        this.browser.setText(html);
    }

    protected IMarker findSelectedSonarIssue(IWorkbenchPart part, ISelection selection) {
        try {
            if (selection instanceof IStructuredSelection) {
                ArrayList<IMarker> selectedSonarMarkers = new ArrayList<IMarker>();
                List elems = ((IStructuredSelection)selection).toList();
                for (Object elem : elems) {
                    AbstractSonarWebView.processElement(selectedSonarMarkers, elem);
                }
                if (!selectedSonarMarkers.isEmpty()) {
                    return (IMarker)selectedSonarMarkers.get(0);
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    private static void processElement(List<IMarker> selectedSonarMarkers, Object elem) throws CoreException {
        IMarker marker;
        if (elem instanceof IMarker) {
            IMarker marker2 = (IMarker)elem;
            if ("org.sonarlint.eclipse.core.sonarlintProblem".equals(marker2.getType())) {
                selectedSonarMarkers.add(marker2);
            }
        } else if (elem instanceof IAdaptable && (marker = (IMarker)((IAdaptable)elem).getAdapter(IMarker.class)) != null && "org.sonarlint.eclipse.core.sonarlintProblem".equals(marker.getType())) {
            selectedSonarMarkers.add(marker);
        }
    }
}

